/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.metanodes;

import kickass.common.exceptions.NotImplementedException;
import kickass.nonasm.tools.tuples.Triple;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.output.reciever.IOutputReciever;
import kickass.pass.asmnode.output.reciever.OutputStreamType;
import kickass.pass.sideeffect.SideEffect;
import kickass.state.EvaluationState;
import kickass.state.FunctionSideOutput;

public class PreSideEffectsNode
extends AsmNode {
    private FunctionSideOutput sideOutput;
    private AsmNode body;

    public PreSideEffectsNode(FunctionSideOutput functionSideOutput, AsmNode asmNode) {
        this.sideOutput = functionSideOutput;
        this.body = asmNode;
    }

    @Override
    public AsmNode copy() {
        throw new NotImplementedException();
    }

    @Override
    public void deliverOutput(IOutputReciever iOutputReciever) {
        for (Triple<OutputStreamType, String, Object> triple : this.sideOutput.getStreamOutput()) {
            iOutputReciever.addToStream(triple.getA(), triple.getB(), triple.getC());
        }
        this.body.deliverOutput(iOutputReciever);
    }

    @Override
    public boolean isFinished() {
        return this.body.isFinished();
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        for (SideEffect sideEffect : this.sideOutput.getSideEffects()) {
            sideEffect.evaluate(evaluationState, null);
        }
        this.body = this.body.executePass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        for (SideEffect sideEffect : this.sideOutput.getSideEffects()) {
            sideEffect.evaluate(evaluationState, null);
        }
        this.body = this.body.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        this.body = this.body.executeMetaRegistrations(evaluationState);
        return this;
    }
}

